local xa6ec2a4af46843f5ba6bc699403c626e = import("LrApplication")
local x80ee7f16424a4ff08ff39c51c52e66ef = import("LrDialogs")
local x74383958d2564384ac9ed6cf7dfe1628 = import("LrErrors")
local xcc109d897ad64c3eb4671d7832836e67 = import("LrFunctionContext")
local xa6b8bc5e6ca343c1a84ecfc31d642372 = import("LrFileUtils")
local xf46a102b660f4b4f99fff91ff8b7c2d1 = import("LrHttp")
local x8b36376c6e924bcdbf3f630320de5f7c = import("LrPathUtils")
local x5e865eb5d80c4547905c9d0e9cb4a96e = import("LrSystemInfo")
local x4f5817500d3e455bb9224cd46f4fcf2c = import("LrTasks")
local x411616e1b6704f698b1afc09a58416ed = import("LrPrefs").prefsForPlugin()
local x31c721477ca74644a40b93d6a3d95fd9 = require("JSON")
require("73080a7c-19f8-49e9-a912-7f4631d5548c")
require("55a14f5d-887f-4fa9-a654-f4bcdcaab8d9")
local x0a084b66860c48bc94f8c9ac5d84755c = x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_API_URL
local x5438b793d2444916b10a89b716c339d4 = x187a46e2a70e4c9697265835bf122e45.MESSAGES
local xb9151dae99d74623b1c4234da6002398 = require("inspect")
local x03d2b9502f71462893ad0c7f9a9e19ea = import("LrLogger")("LightfolioLR")
x84a0312622714ecaa30b5010f1ea1287.configureLogger()
x19200da09b414d33933a33548d62156d = {}
local function buildGetRequest(x26d40bd4b37a4647abd22e928ff0fcaf)
  return string.format("token=%s&employees_guid=%s", x26d40bd4b37a4647abd22e928ff0fcaf.token, x26d40bd4b37a4647abd22e928ff0fcaf.employeesGuid)
  end
function x19200da09b414d33933a33548d62156d.callApi(x3e011aeb84c2401fb62b559bc1950f78, x851e83636f86449f9a7628df4f02a10e, xdf83f89383764c9897a2b6dc57da4c3f, xb8924841b00048c6ad3c8020fa819561)
  xdf83f89383764c9897a2b6dc57da4c3f = "version=" .. url_encode(x187a46e2a70e4c9697265835bf122e45.PLUGIN_VERSION) .. "&" .. xdf83f89383764c9897a2b6dc57da4c3f
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("LF API HTTP [" .. x3e011aeb84c2401fb62b559bc1950f78 .. "]: " .. x851e83636f86449f9a7628df4f02a10e .. "/?" .. xdf83f89383764c9897a2b6dc57da4c3f)
  
  local xcbf99c9466954c17b128932af1653e73, x7f33f8f87c414864975b21fe87bac6d7
  if x3e011aeb84c2401fb62b559bc1950f78 == "GET" then
  xcbf99c9466954c17b128932af1653e73, x7f33f8f87c414864975b21fe87bac6d7 = xf46a102b660f4b4f99fff91ff8b7c2d1.get(x851e83636f86449f9a7628df4f02a10e .. "/?" .. xdf83f89383764c9897a2b6dc57da4c3f, xb8924841b00048c6ad3c8020fa819561, x187a46e2a70e4c9697265835bf122e45.TIMEOUT_API)
  elseif x3e011aeb84c2401fb62b559bc1950f78 == "POST" then
  xcbf99c9466954c17b128932af1653e73, x7f33f8f87c414864975b21fe87bac6d7 = xf46a102b660f4b4f99fff91ff8b7c2d1.post(x851e83636f86449f9a7628df4f02a10e, xdf83f89383764c9897a2b6dc57da4c3f, xb8924841b00048c6ad3c8020fa819561, "POST", x187a46e2a70e4c9697265835bf122e45.TIMEOUT_API)
  end
  if not xcbf99c9466954c17b128932af1653e73 or x7f33f8f87c414864975b21fe87bac6d7.status ~= 200 then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Connection error", "Please check your internet connection and try again.", "critical")
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Lightfolio API failure. xb8924841b00048c6ad3c8020fa819561: " .. (xb8924841b00048c6ad3c8020fa819561 or "no x7f33f8f87c414864975b21fe87bac6d7"))
  xcbf99c9466954c17b128932af1653e73 = "{\"success\":false, \"error\":\"\"}"
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("LF API xcbf99c9466954c17b128932af1653e73 [" .. x3e011aeb84c2401fb62b559bc1950f78 .. "]:", xcbf99c9466954c17b128932af1653e73)
  
  xcbf99c9466954c17b128932af1653e73 = x31c721477ca74644a40b93d6a3d95fd9:decode(xcbf99c9466954c17b128932af1653e73)
  
  if xcbf99c9466954c17b128932af1653e73.error ~= nil and xcbf99c9466954c17b128932af1653e73.error == "Unathenticated" then
  x74383958d2564384ac9ed6cf7dfe1628.throwUserError("You must first log in.")
  end
  return xcbf99c9466954c17b128932af1653e73
  end
function x19200da09b414d33933a33548d62156d.authenticate( xcad8ba125cfe408fadb9cd2cb42d3107 )
  x03d2b9502f71462893ad0c7f9a9e19ea:info("API:Authenticate")
  local x30b2134e28a742e5b0654cad33d77f71 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "GetToken", string.format("app_id=%s&api_key=%s&email=%s&password=%s&app_info=%s&client_info=%s", _PLUGIN.id, API_KEY, url_encode(xcad8ba125cfe408fadb9cd2cb42d3107.email), url_encode(xcad8ba125cfe408fadb9cd2cb42d3107.password), url_encode("Lightroom " .. xa6ec2a4af46843f5ba6bc699403c626e.versionString()), url_encode(x5e865eb5d80c4547905c9d0e9cb4a96e.summaryString())))
  if x30b2134e28a742e5b0654cad33d77f71 and x30b2134e28a742e5b0654cad33d77f71.success then
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Logged in. Token:", xcad8ba125cfe408fadb9cd2cb42d3107.token)
  xcad8ba125cfe408fadb9cd2cb42d3107.password = nil
  xcad8ba125cfe408fadb9cd2cb42d3107.token = tostring(x30b2134e28a742e5b0654cad33d77f71.data.token)
  xcad8ba125cfe408fadb9cd2cb42d3107.employeesGuid = tostring(x30b2134e28a742e5b0654cad33d77f71.data.employees_guid)
  xcad8ba125cfe408fadb9cd2cb42d3107.username = tostring(x30b2134e28a742e5b0654cad33d77f71.data.username)
  xcad8ba125cfe408fadb9cd2cb42d3107.companyName = tostring(x30b2134e28a742e5b0654cad33d77f71.data.company_name)
  xcad8ba125cfe408fadb9cd2cb42d3107.plan = tostring(x30b2134e28a742e5b0654cad33d77f71.data.plan)
  xcad8ba125cfe408fadb9cd2cb42d3107.storage = tostring(x30b2134e28a742e5b0654cad33d77f71.data.storage)
  xcad8ba125cfe408fadb9cd2cb42d3107.storageExceeded = x30b2134e28a742e5b0654cad33d77f71.data.storage_exceeded
  return true
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(x30b2134e28a742e5b0654cad33d77f71.error))
  if x30b2134e28a742e5b0654cad33d77f71.error ~= "" then
  x74383958d2564384ac9ed6cf7dfe1628.throwUserError(tostring(x30b2134e28a742e5b0654cad33d77f71.error))
  end
  end
  end
function x19200da09b414d33933a33548d62156d.validateToken( xdd6ca5eacce7410b8c9e98ef77580161 )
  x03d2b9502f71462893ad0c7f9a9e19ea:info("API:ValidateToken")
  xdd6ca5eacce7410b8c9e98ef77580161.accountStatusText = "Authenticating..."
  xdd6ca5eacce7410b8c9e98ef77580161.emailFieldEnabled = false
  xdd6ca5eacce7410b8c9e98ef77580161.passwordFieldEnabled = false
  xdd6ca5eacce7410b8c9e98ef77580161.enableLogin = false
  local x70df6a9ba05b4284a989b34e4504be13 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "ValidateToken", buildGetRequest(xdd6ca5eacce7410b8c9e98ef77580161))
  if x70df6a9ba05b4284a989b34e4504be13 and x70df6a9ba05b4284a989b34e4504be13.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Token validated")
  x03d2b9502f71462893ad0c7f9a9e19ea:debug(xb9151dae99d74623b1c4234da6002398(x70df6a9ba05b4284a989b34e4504be13))
  return true
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error or invalid token:", tostring(x70df6a9ba05b4284a989b34e4504be13.error))
  return false
  end
  end
function x19200da09b414d33933a33548d62156d.logout( x43ca2199d1a34414991bd58e479d0f6b )
  x03d2b9502f71462893ad0c7f9a9e19ea:info("API:Logout")
  local x7ceedfaa3ee641d0ba137212e14dfb0e = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "Logout", buildGetRequest(tblProperties))
  if x7ceedfaa3ee641d0ba137212e14dfb0e and x7ceedfaa3ee641d0ba137212e14dfb0e.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Logged out")
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(x7ceedfaa3ee641d0ba137212e14dfb0e.error))
  end
  end
function x19200da09b414d33933a33548d62156d.publishCompleted( x043dac38dfa0416ca3fc43a02f1554c4, x4c8c6f26588e4cabbc6cbfa521bfaa1f ) 
  x03d2b9502f71462893ad0c7f9a9e19ea:info("API:publishCompleted")
  local x3d08c07e778546d88d862473e6ef96b0 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "PublishCompleted", buildGetRequest(x043dac38dfa0416ca3fc43a02f1554c4) .. "&collection_id=" .. x4c8c6f26588e4cabbc6cbfa521bfaa1f)
  if x3d08c07e778546d88d862473e6ef96b0 and x3d08c07e778546d88d862473e6ef96b0.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Success")
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(x3d08c07e778546d88d862473e6ef96b0.error))
  end
  end
function x19200da09b414d33933a33548d62156d.getCollectionUrl(x7a50e93caab94454bc9a47d409dcdd39, xb87b76c31168406bbbdffe170ff79595)
  if x7a50e93caab94454bc9a47d409dcdd39 and xb87b76c31168406bbbdffe170ff79595 then
  return x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_URL .. "galleries/folder.aspx?cid=" .. x7a50e93caab94454bc9a47d409dcdd39 .. "&g=" .. xb87b76c31168406bbbdffe170ff79595
  elseif x7a50e93caab94454bc9a47d409dcdd39 then
  return x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_URL .. "galleries/dashboard.aspx?cid=" .. x7a50e93caab94454bc9a47d409dcdd39
  else
  return x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_URL .. "galleries"
  end
  end
function x19200da09b414d33933a33548d62156d.getLightboxUrl(x7ffb269add9b4855a6f760ad97858fd6, x9ba15d5eb42747528a3fb14ed003f7a0)
  return x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_URL .. "galleries/lightboxes.aspx?cid=" .. x7ffb269add9b4855a6f760ad97858fd6 .. "&lbid=" .. x9ba15d5eb42747528a3fb14ed003f7a0
  end
local function cleanupCollectionsAndFolders( x0072effd57754970a67ec023be28ece9, xbddc6b908eb34fab89d24b1c6d657f9a, x25ba2483864b47c780c0689f5525708e )
  local x62c8afbe2b984b9d8ea578bc7995d2d5 = false
  local x56d353f7dade413985d8c88835fdc2d9 = false
  
  
  local x5221cf8672a34d4c9f2e143c18f22e24, x691be93379314f80a00d7bdd4c4a6131, x0215c6a3a2bc4dfca78a6c103443a268, xe35c19fe97ac4e919cd0c2215e6983c8 = xddaa718deba64f87b15382b579451708.getCollectionSetsAndCollections(x0072effd57754970a67ec023be28ece9)
  
  for id, collectionSetInfo in pairs(x5221cf8672a34d4c9f2e143c18f22e24) do
  x0072effd57754970a67ec023be28ece9.catalog:withWriteAccessDo("", function()
  
  
  if not xbddc6b908eb34fab89d24b1c6d657f9a[id] then
  local x45aabf159c244fa4ba5218783acc218d = collectionSetInfo.collectionSet:getName()
  
  if x62c8afbe2b984b9d8ea578bc7995d2d5 then
  
  collectionSetInfo.collectionSet:delete()
  else
  local x30f61075eff64328a8a077358b28d856 = x80ee7f16424a4ff08ff39c51c52e66ef.confirm("Missing Gallery", string.format("Gallery '%s' has been deleted from Lightfolio. Remove it from Lightroom?", x45aabf159c244fa4ba5218783acc218d), "Remove", "Keep", "Remove All")
  
  if x30f61075eff64328a8a077358b28d856 == "ok" then
  
  collectionSetInfo.collectionSet:delete()
  elseif x30f61075eff64328a8a077358b28d856 == "other" then
  
  collectionSetInfo.collectionSet:delete()
  x62c8afbe2b984b9d8ea578bc7995d2d5 = true
  end
  end
  end
  end)
  end
  
  
  x5221cf8672a34d4c9f2e143c18f22e24, x691be93379314f80a00d7bdd4c4a6131, x0215c6a3a2bc4dfca78a6c103443a268, xe35c19fe97ac4e919cd0c2215e6983c8 = xddaa718deba64f87b15382b579451708.getCollectionSetsAndCollections(x0072effd57754970a67ec023be28ece9)
  
  for id, collectionInfo in pairs(x0215c6a3a2bc4dfca78a6c103443a268) do
  x0072effd57754970a67ec023be28ece9.catalog:withWriteAccessDo("", function()
  if not x25ba2483864b47c780c0689f5525708e[id] then
  local xcb805898f00245918c8b3c75c5607ba7 = collectionInfo.collection:getName()
  if x56d353f7dade413985d8c88835fdc2d9 then
  
  collectionInfo.collection:delete()
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Folder missing: " .. id)
  local x0c26b3cb2cd14bc184f9235a87cc6c8a = x80ee7f16424a4ff08ff39c51c52e66ef.confirm("Missing Folder", string.format("Folder '%s' has been deleted from Lightfolio. Remove it from Lightroom?", xcb805898f00245918c8b3c75c5607ba7), "Remove", "Keep", "Remove All")
  if x0c26b3cb2cd14bc184f9235a87cc6c8a == "ok" then
  
  collectionInfo.collection:delete()
  elseif x0c26b3cb2cd14bc184f9235a87cc6c8a == "other" then
  
  collectionInfo.collection:delete()
  x56d353f7dade413985d8c88835fdc2d9 = true
  end
  end
  end
  end)
  end
  
  
  x5221cf8672a34d4c9f2e143c18f22e24, x691be93379314f80a00d7bdd4c4a6131, x0215c6a3a2bc4dfca78a6c103443a268, xe35c19fe97ac4e919cd0c2215e6983c8 = xddaa718deba64f87b15382b579451708.getCollectionSetsAndCollections(x0072effd57754970a67ec023be28ece9)
  
  return x5221cf8672a34d4c9f2e143c18f22e24, x691be93379314f80a00d7bdd4c4a6131, x0215c6a3a2bc4dfca78a6c103443a268, xe35c19fe97ac4e919cd0c2215e6983c8
  end
function x19200da09b414d33933a33548d62156d.syncCollections( xc0a97c9a444948ba962afbd6d6c37eb8 )
  local x9f0b1c25dc2349829be7b88cd2bb818d = xc0a97c9a444948ba962afbd6d6c37eb8.LR_publishService
  
  local function xdda47c650bac4b6f8a13230cae00d07b(context, x99f75cec20114cb9b9e01c43a143a754)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Syncing Collections")
  x80ee7f16424a4ff08ff39c51c52e66ef.attachErrorDialogToFunctionContext(context)
  context:addFailureHandler(function()
  x03d2b9502f71462893ad0c7f9a9e19ea:tracef("[syncCollections]:")
  end)
  
  local xe7ce278e8ba74e6bb47025a8079eb56b = {}
  local x22fff4266f0e4712830493e6507d2e3e = {}
  local x9a13ae59c45140a3bd93315602d65280 = 0
  local x9e5c3f710e4e4830b423d39897b242a9 = 0
  
  local xb4a0ab7162e443ac809f7148083ef77e = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "getAllCollections", buildGetRequest(xc0a97c9a444948ba962afbd6d6c37eb8))
  if not xb4a0ab7162e443ac809f7148083ef77e or xb4a0ab7162e443ac809f7148083ef77e and not xb4a0ab7162e443ac809f7148083ef77e.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(xb4a0ab7162e443ac809f7148083ef77e.error))
  return false
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("show response syncCollections")
  x03d2b9502f71462893ad0c7f9a9e19ea:debug(xb9151dae99d74623b1c4234da6002398(xb4a0ab7162e443ac809f7148083ef77e))
  
  for _, collectionSetObj in ipairs(xb4a0ab7162e443ac809f7148083ef77e.data) do
  xe7ce278e8ba74e6bb47025a8079eb56b[tostring(collectionSetObj.collection_id)] = collectionSetObj
  for _, objCollection in ipairs(collectionSetObj.folders) do
  x22fff4266f0e4712830493e6507d2e3e[tostring(objCollection.folder_id)] = objCollection
  end
  x9e5c3f710e4e4830b423d39897b242a9 = x9e5c3f710e4e4830b423d39897b242a9 + 1
  end
  
  
  local xfba698ae936548d4a2cb97c7dc818f7e, x9e1c58c808484414a1c6e69906866993, xf3d57c3bb66a4bd1972d6bab6fe873a6, xa82771746fe54233831be35f45f83905 = cleanupCollectionsAndFolders(x9f0b1c25dc2349829be7b88cd2bb818d, xe7ce278e8ba74e6bb47025a8079eb56b, x22fff4266f0e4712830493e6507d2e3e)
  
  
  
  for cid, collectionSetObj in pairs(xe7ce278e8ba74e6bb47025a8079eb56b) do
  do
  local xc701a2082a204e71917ac07938962b8e
  
  
  x9f0b1c25dc2349829be7b88cd2bb818d.catalog:withWriteAccessDo("", function()
  local xb930b5c8bcc64dc7ab0724c2254d5ddf
  local xd989e8e12a864fa88945e5e6d746d096 = collectionSetObj.collection_name
  
  
  if xfba698ae936548d4a2cb97c7dc818f7e[cid] then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Updating xc701a2082a204e71917ac07938962b8e by cid:", xd989e8e12a864fa88945e5e6d746d096)
  local xaff14b6a4f8e4f5590ff96dbf9e47ab6 = xfba698ae936548d4a2cb97c7dc818f7e[cid]
  xc701a2082a204e71917ac07938962b8e = xaff14b6a4f8e4f5590ff96dbf9e47ab6.collectionSet
  xb930b5c8bcc64dc7ab0724c2254d5ddf = xc701a2082a204e71917ac07938962b8e:getCollectionSetInfoSummary().collectionSettings or {}
  
  
  
  
  
  
  
  if xc701a2082a204e71917ac07938962b8e:getName() ~= xd989e8e12a864fa88945e5e6d746d096 and not xc701a2082a204e71917ac07938962b8e:setName(xd989e8e12a864fa88945e5e6d746d096) then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Sync Error", "Unable to rename folder '" .. xc701a2082a204e71917ac07938962b8e:getName() .. "' to '" .. xd989e8e12a864fa88945e5e6d746d096 .. "' because another Lightroom folder with that name already exists.", "critical")
  end
  elseif x9e1c58c808484414a1c6e69906866993[xd989e8e12a864fa88945e5e6d746d096] then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Updating collection by xd989e8e12a864fa88945e5e6d746d096:", xd989e8e12a864fa88945e5e6d746d096, cid)
  local xaff14b6a4f8e4f5590ff96dbf9e47ab6 = x9e1c58c808484414a1c6e69906866993[xd989e8e12a864fa88945e5e6d746d096]
  xc701a2082a204e71917ac07938962b8e = xaff14b6a4f8e4f5590ff96dbf9e47ab6.collectionSet
  xb930b5c8bcc64dc7ab0724c2254d5ddf = xc701a2082a204e71917ac07938962b8e:getCollectionSetInfoSummary().collectionSettings or {}
  
  
  
  
  else
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Creating collection:", cid, xd989e8e12a864fa88945e5e6d746d096)
  xc701a2082a204e71917ac07938962b8e = x9f0b1c25dc2349829be7b88cd2bb818d:createPublishedCollectionSet(xd989e8e12a864fa88945e5e6d746d096, nil, false)
  
  if not xc701a2082a204e71917ac07938962b8e then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Sync Error", "Unable to create the folder '" .. xd989e8e12a864fa88945e5e6d746d096 .. "' because another folder with that name already exists in Lightroom.", "critical")
  return
  end
  
  
  
  
  end
  
  
  
  
  
  
  
  
  local x5560999dc3cc4e66a05cd07cbf61d2f8 = x19200da09b414d33933a33548d62156d.getCollectionUrl(cid)
  xc701a2082a204e71917ac07938962b8e:setRemoteUrl(x5560999dc3cc4e66a05cd07cbf61d2f8)
  xc701a2082a204e71917ac07938962b8e:setRemoteId(cid)
  xc701a2082a204e71917ac07938962b8e:setCollectionSetSettings(xb930b5c8bcc64dc7ab0724c2254d5ddf)
  
  
  for _, objCollection in pairs(collectionSetObj.folders) do
  local x4bd344348dc149a787bd78c9e481de5f = objCollection.folder_id
  local xe5441c6d32ae4f218cfb73b529b74b4b
  local xa1afe9f38f944af192610af0ea2bc675 = objCollection.folder_name
  
  if xf3d57c3bb66a4bd1972d6bab6fe873a6[x4bd344348dc149a787bd78c9e481de5f] then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Updating folder by x4bd344348dc149a787bd78c9e481de5f:", xa1afe9f38f944af192610af0ea2bc675)
  local x30ef010184d0488e99819eb633bd78fd = xf3d57c3bb66a4bd1972d6bab6fe873a6[x4bd344348dc149a787bd78c9e481de5f]
  xe5441c6d32ae4f218cfb73b529b74b4b = x30ef010184d0488e99819eb633bd78fd.collection
  
  
  
  if xe5441c6d32ae4f218cfb73b529b74b4b:getName() ~= xa1afe9f38f944af192610af0ea2bc675 and not xe5441c6d32ae4f218cfb73b529b74b4b:setName(xa1afe9f38f944af192610af0ea2bc675) then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Sync Error", "Unable to rename Folder '" .. xe5441c6d32ae4f218cfb73b529b74b4b:getName() .. "' to '" .. xa1afe9f38f944af192610af0ea2bc675 .. "' as another Folder with that name already exists in Lightroom.", "critical")
  end
  elseif xa82771746fe54233831be35f45f83905[xd989e8e12a864fa88945e5e6d746d096 .. "/" .. xa1afe9f38f944af192610af0ea2bc675] then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Updating folder by xa1afe9f38f944af192610af0ea2bc675:", xa1afe9f38f944af192610af0ea2bc675, x4bd344348dc149a787bd78c9e481de5f)
  local x30ef010184d0488e99819eb633bd78fd = xa82771746fe54233831be35f45f83905[xd989e8e12a864fa88945e5e6d746d096 .. "/" .. xa1afe9f38f944af192610af0ea2bc675]
  xe5441c6d32ae4f218cfb73b529b74b4b = x30ef010184d0488e99819eb633bd78fd.collection
  else
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Creating folder:", objCollection.folder_id, xa1afe9f38f944af192610af0ea2bc675)
  xe5441c6d32ae4f218cfb73b529b74b4b = x9f0b1c25dc2349829be7b88cd2bb818d:createPublishedCollection(xa1afe9f38f944af192610af0ea2bc675, xc701a2082a204e71917ac07938962b8e, false)
  if not xe5441c6d32ae4f218cfb73b529b74b4b then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Sync Error", "Could not create the Folder '" .. xa1afe9f38f944af192610af0ea2bc675 .. "' as another Folder with that name already exists in Lightroom.", "critical")
  return
  end
  end
  
  
  local x8c32f54d840c49b4a09ff0de77483cbb = x19200da09b414d33933a33548d62156d.getCollectionUrl(cid, objCollection.shortName)
  xe5441c6d32ae4f218cfb73b529b74b4b:setRemoteUrl(x8c32f54d840c49b4a09ff0de77483cbb)
  xe5441c6d32ae4f218cfb73b529b74b4b:setRemoteId(x4bd344348dc149a787bd78c9e481de5f)
  end
  end)
  
  
  
  
  
  
  x9a13ae59c45140a3bd93315602d65280 = x9a13ae59c45140a3bd93315602d65280 + 1
  x99f75cec20114cb9b9e01c43a143a754:setPortionComplete(x9a13ae59c45140a3bd93315602d65280 / x9e5c3f710e4e4830b423d39897b242a9)
  x4f5817500d3e455bb9224cd46f4fcf2c.yield()
  end
  end
  
  syncLightboxes(xc0a97c9a444948ba962afbd6d6c37eb8, xb4a0ab7162e443ac809f7148083ef77e.data, context)
  end
  
  xcc109d897ad64c3eb4671d7832836e67.postAsyncTaskWithContext("Sync collections", function(context)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("syncCollections sync")
  local x99f75cec20114cb9b9e01c43a143a754 = x80ee7f16424a4ff08ff39c51c52e66ef.showModalProgressDialog({
  title = "Lightfolio Sync",
  caption = "Retrieving Galleries from Lightfolio...",
  cannotCancel = true,
  functionContext = context
  })
  xdda47c650bac4b6f8a13230cae00d07b(context, x99f75cec20114cb9b9e01c43a143a754)
  end)
  end
function x19200da09b414d33933a33548d62156d.getCollectionDefaultFolders(xbacfb6b2d9f5418ab4e433a67092a974)
  local x699047a073f24a1fac7998b5927544bb = x19200da09b414d33933a33548d62156d.callApi("GET", x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_API_URL .. "getCollectionDefaultFolders", buildGetRequest(xbacfb6b2d9f5418ab4e433a67092a974) .. "&collection_default_id=" .. collectionDefaultId)
  if x699047a073f24a1fac7998b5927544bb and x699047a073f24a1fac7998b5927544bb.success then
  return x699047a073f24a1fac7998b5927544bb.data.default_sets
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API returned error:", tostring(x699047a073f24a1fac7998b5927544bb.error))
  return {"Images"}
  end
  end
function x19200da09b414d33933a33548d62156d.getAccountUsage(xeeb98b6f2ce949a1985b5178ad7c57dc)
  local xd098e501902242009f968a0f4671e387 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "getAccountUsage", buildGetRequest(xeeb98b6f2ce949a1985b5178ad7c57dc))
  if xd098e501902242009f968a0f4671e387 and xd098e501902242009f968a0f4671e387.success then
  xeeb98b6f2ce949a1985b5178ad7c57dc.accountStatus = tostring(xd098e501902242009f968a0f4671e387.data.account_status)
  xeeb98b6f2ce949a1985b5178ad7c57dc.plan = tostring(xd098e501902242009f968a0f4671e387.data.plan)
  xeeb98b6f2ce949a1985b5178ad7c57dc.storage = tostring(xd098e501902242009f968a0f4671e387.data.storage)
  xeeb98b6f2ce949a1985b5178ad7c57dc.exceedsMax = xd098e501902242009f968a0f4671e387.data.exceeds_max
  if xeeb98b6f2ce949a1985b5178ad7c57dc.exceedsMax then
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Account storage limit exceeded ", xeeb98b6f2ce949a1985b5178ad7c57dc.storage)
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Publish Error", string.format("%s storage limit exceeded. Please upgrade your account or delete some photos from your galleries.", xeeb98b6f2ce949a1985b5178ad7c57dc.storage), "critical")
  return
  elseif xeeb98b6f2ce949a1985b5178ad7c57dc.accountStatus == "Suspended" or xeeb98b6f2ce949a1985b5178ad7c57dc.accountStatus == "Closed" then
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Uploading failure. Account status: ", xeeb98b6f2ce949a1985b5178ad7c57dc.accountStatus)
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Publish Error", string.format("Account status: %s. Please email support@lightfolio.com", xeeb98b6f2ce949a1985b5178ad7c57dc.accountStatus), "critical")
  return
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:info("checkAccountUsage", "completed successfully")
  end
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(xd098e501902242009f968a0f4671e387.error))
  end
  
  return xeeb98b6f2ce949a1985b5178ad7c57dc
  end
function x19200da09b414d33933a33548d62156d.getUploadParams(x7c3c01e3e0144abea7e5ff2b0d4021e1)
  local x3dec5afd702a4c93a4f217d59481649e = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "getUploadParams", buildGetRequest(x7c3c01e3e0144abea7e5ff2b0d4021e1))
  if x3dec5afd702a4c93a4f217d59481649e and x3dec5afd702a4c93a4f217d59481649e.success then
  return tostring(x3dec5afd702a4c93a4f217d59481649e.data.endpoint)
  
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(x3dec5afd702a4c93a4f217d59481649e.error))
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Publish Error", "Please email support@lightfolio.com", "critical")
  return ""
  end
  end
function x19200da09b414d33933a33548d62156d.getSetAndCollection(xe025016467e44cf3bdfb37be61ce12ed, x248109d451f740b8b074d92275d52f9d, x9fb130be3be14ca7813d60abf8cc2931, xe3fda565393149a580939474c952e31e, xf6036b65095444a893c7aa77f7734e9e, x6abddc2def3546b1b496632ce56c0b30)
  local xec85653d8c634cf18c453ea9536d7a44 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "getSetAndCollection", buildGetRequest(xe025016467e44cf3bdfb37be61ce12ed) .. string.format("&folder_name=%s&folder_id=%s&collection_name=%s&collection_id=%s&collection_default_id=%s", url_encode(x248109d451f740b8b074d92275d52f9d), x9fb130be3be14ca7813d60abf8cc2931, url_encode(xe3fda565393149a580939474c952e31e), xf6036b65095444a893c7aa77f7734e9e, x6abddc2def3546b1b496632ce56c0b30))
  local x1aff8bce4ad24f1cb345db72bca7ad7d = ""
  local x84f58bde268b4b91a2257ec55ebb4774 = ""
  local x18636382b47f458b8c1262bb32a1fd0f = ""
  local xdc284101914e449dac481f422c6930e7 = ""
  local xd9d701dad3454353814f047886ea9892 = false
  local xbaea908d032a43739d1b999b66a8a0d4 = false
  
  if xec85653d8c634cf18c453ea9536d7a44 and xec85653d8c634cf18c453ea9536d7a44.success then
  xf6036b65095444a893c7aa77f7734e9e = tostring(xec85653d8c634cf18c453ea9536d7a44.data.collection_id)
  xe3fda565393149a580939474c952e31e = tostring(xec85653d8c634cf18c453ea9536d7a44.data.collection_name)
  x1aff8bce4ad24f1cb345db72bca7ad7d = tostring(xec85653d8c634cf18c453ea9536d7a44.data.collection_shortname)
  x84f58bde268b4b91a2257ec55ebb4774 = tostring(xec85653d8c634cf18c453ea9536d7a44.data.folder_id)
  x18636382b47f458b8c1262bb32a1fd0f = tostring(xec85653d8c634cf18c453ea9536d7a44.data.folder_name)
  xdc284101914e449dac481f422c6930e7 = tostring(xec85653d8c634cf18c453ea9536d7a44.data.folder_shortname)
  xd9d701dad3454353814f047886ea9892 = xec85653d8c634cf18c453ea9536d7a44.data.new_collection
  xbaea908d032a43739d1b999b66a8a0d4 = xec85653d8c634cf18c453ea9536d7a44.data.new_folder
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API returned error:", tostring(xec85653d8c634cf18c453ea9536d7a44.error))
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Publish Error", "Could not create the Folder. Please email support@lightfolio.com", "critical")
  end
  
  return xf6036b65095444a893c7aa77f7734e9e, xe3fda565393149a580939474c952e31e, x1aff8bce4ad24f1cb345db72bca7ad7d, x84f58bde268b4b91a2257ec55ebb4774, x18636382b47f458b8c1262bb32a1fd0f, xdc284101914e449dac481f422c6930e7, xd9d701dad3454353814f047886ea9892, xbaea908d032a43739d1b999b66a8a0d4
  end
function x19200da09b414d33933a33548d62156d.getNewCollectionSettings( x1dc36cb9b05444b297f583c6d21c7a57, xe2b6f0a495e94790a5db7db7c81c3d3c )
  local xba5a1782c00e47e08020687b32d319c5 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "GetNewCollectionSettings", buildGetRequest(x1dc36cb9b05444b297f583c6d21c7a57))
  if xba5a1782c00e47e08020687b32d319c5 and xba5a1782c00e47e08020687b32d319c5.success then
  
  local x3789dd9909c04bf7aaf10d728b1e0c24 = xe2b6f0a495e94790a5db7db7c81c3d3c.collectionSettings
  xe2b6f0a495e94790a5db7db7c81c3d3c.publishService.catalog:withWriteAccessDo("", function()
  local x6d497aefe42a42e7b03f0c74ccbe116a = {}
  for _, collectionDefault in pairs(xba5a1782c00e47e08020687b32d319c5.data.collection_defaults) do
  table.insert(x6d497aefe42a42e7b03f0c74ccbe116a, {
  value = collectionDefault.folder_id, 
  title = collectionDefault.folder_name
  })
  end
  x3789dd9909c04bf7aaf10d728b1e0c24.isNewCollection = true
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("#x6d497aefe42a42e7b03f0c74ccbe116a", #x6d497aefe42a42e7b03f0c74ccbe116a)
  
  if #x6d497aefe42a42e7b03f0c74ccbe116a > 1 then
  x3789dd9909c04bf7aaf10d728b1e0c24.collectionDefaults = x6d497aefe42a42e7b03f0c74ccbe116a
  x3789dd9909c04bf7aaf10d728b1e0c24.selectedCollectionDefault = x6d497aefe42a42e7b03f0c74ccbe116a[2] ~= nil and x6d497aefe42a42e7b03f0c74ccbe116a[2].value or 0
  else
  x3789dd9909c04bf7aaf10d728b1e0c24.collectionDefaults = nil
  x3789dd9909c04bf7aaf10d728b1e0c24.selectedCollectionDefault = 0
  end
  end)
  return true
  
  else
  local xa672a0c24320473ebe26714bed936117 = tostring(xba5a1782c00e47e08020687b32d319c5.error)
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", xa672a0c24320473ebe26714bed936117)
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Unable to create new Collection", xa672a0c24320473ebe26714bed936117, "critical")
  return false
  end
  end
function x19200da09b414d33933a33548d62156d.getCollection( x534b698f034748a4b2b2662dcc93464e, x9d57ba1870b241e7bf4f424356049389 )
  local x4536c3878a5a444bb1206c43ad366520 = x9d57ba1870b241e7bf4f424356049389.publishedCollection
  local xf40fcdb7493b42f2a0961d0470613bea = x4536c3878a5a444bb1206c43ad366520:getRemoteId()
  local x079f05d7841f4c01a45f91462762e859 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "GetCollection", buildGetRequest(x534b698f034748a4b2b2662dcc93464e) .. "&collection_id=" .. xf40fcdb7493b42f2a0961d0470613bea)
  if x079f05d7841f4c01a45f91462762e859 and x079f05d7841f4c01a45f91462762e859.success then
  
  local x7da7f33d68bf45bf8baeb7b6db15350f = x4536c3878a5a444bb1206c43ad366520:getCollectionSetInfoSummary().collectionSettings
  x9d57ba1870b241e7bf4f424356049389.publishService.catalog:withWriteAccessDo("", function()
  x7da7f33d68bf45bf8baeb7b6db15350f.collectionDefaults = nil
  x4536c3878a5a444bb1206c43ad366520:setCollectionSetSettings(x7da7f33d68bf45bf8baeb7b6db15350f)
  end)
  return true
  
  else
  local xf02aafa5f13c4112bea9552afc8a80f2 = tostring(x079f05d7841f4c01a45f91462762e859.error)
  if string.find(xf02aafa5f13c4112bea9552afc8a80f2, "not exist") ~= nil then
  x9d57ba1870b241e7bf4f424356049389.publishService.catalog:withWriteAccessDo("", function(context)
  x4536c3878a5a444bb1206c43ad366520:setRemoteId(nil)
  x4536c3878a5a444bb1206c43ad366520:setRemoteUrl(nil)
  end)
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Remote Collection DOES NOT EXIST, unsetting id and url")
  xf02aafa5f13c4112bea9552afc8a80f2 = xf02aafa5f13c4112bea9552afc8a80f2 .. x5438b793d2444916b10a89b716c339d4.CATALOG_SYNC_ERROR
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", xf02aafa5f13c4112bea9552afc8a80f2)
  end
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Unable to edit Collection Settings", xf02aafa5f13c4112bea9552afc8a80f2, "critical")
  return false
  end
  end
function x19200da09b414d33933a33548d62156d.updateCollection( x52089260ad2a4fd48f8876597724eb2a, xeec350b026d940e7843546f5236ad0bd )
  local xe53843924505400699fd3ab1ba3b13fe = xeec350b026d940e7843546f5236ad0bd.publishedCollection
  local x9486e2eb834a4b898ea8c23f734cab43 = xe53843924505400699fd3ab1ba3b13fe:getRemoteId()
  local x20fb8e2b9aff48b392bfde15900214ca = url_encode(xeec350b026d940e7843546f5236ad0bd.name)
  local xdf9e965375ae470c8c1cdd7dee4274cf = xeec350b026d940e7843546f5236ad0bd.collectionSettings
  local x1daecac1c1a64965b0b7b024f76fdac6 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "UpdateCollection", buildGetRequest(x52089260ad2a4fd48f8876597724eb2a) .. string.format("&collection_id=%s&name=%s", x9486e2eb834a4b898ea8c23f734cab43, x20fb8e2b9aff48b392bfde15900214ca))
  if x1daecac1c1a64965b0b7b024f76fdac6 and x1daecac1c1a64965b0b7b024f76fdac6.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Update Collection settings ok")
  
  local xc4e15a1bbd54454cb26f0eee6bf949cb = xe53843924505400699fd3ab1ba3b13fe:getCollectionSetInfoSummary().collectionSettings
  xeec350b026d940e7843546f5236ad0bd.publishService.catalog:withWriteAccessDo("", function()
  xe53843924505400699fd3ab1ba3b13fe:setCollectionSetSettings(xc4e15a1bbd54454cb26f0eee6bf949cb)
  end)
  
  else
  local xa7f5e5dbff554a979c38758ee66fdf2a = tostring(x1daecac1c1a64965b0b7b024f76fdac6.error) .. x5438b793d2444916b10a89b716c339d4.CATALOG_SYNC_ERROR
  if string.find(xa7f5e5dbff554a979c38758ee66fdf2a, "not exist") ~= nil then
  xeec350b026d940e7843546f5236ad0bd.publishService.catalog:withWriteAccessDo("", function(context)
  xe53843924505400699fd3ab1ba3b13fe:setRemoteId(nil)
  xe53843924505400699fd3ab1ba3b13fe:setRemoteUrl(nil)
  end)
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Remote Collection DOES NOT EXIST, unsetting id and url")
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Unable to rename the Collection on Lightfolio", xa7f5e5dbff554a979c38758ee66fdf2a)
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", xa7f5e5dbff554a979c38758ee66fdf2a)
  if xa7f5e5dbff554a979c38758ee66fdf2a ~= "" then
  x74383958d2564384ac9ed6cf7dfe1628.throwUserError(xa7f5e5dbff554a979c38758ee66fdf2a)
  end
  end
  end
  end
function x19200da09b414d33933a33548d62156d.renameCollection( x02f96c3157f942b5901e8b7c9d765de8, xf31f4feaea164a9d8157b597c2353dc6 )
  local xdaa77044f54943a2ba58ce348478d5ab = xf31f4feaea164a9d8157b597c2353dc6.remoteId
  local x47e4e2f5f0894d1898b04e504ada29f5 = url_encode(xf31f4feaea164a9d8157b597c2353dc6.name)
  local xa824ebbfaa17487f95e173d3cc78b018 = xf31f4feaea164a9d8157b597c2353dc6.publishedCollection
  local x34fa72d99b5346c3b52217c0310be9c7 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "UpdateCollection", buildGetRequest(x02f96c3157f942b5901e8b7c9d765de8) .. string.format("&collection_id=%s&name=%s", xdaa77044f54943a2ba58ce348478d5ab, x47e4e2f5f0894d1898b04e504ada29f5))
  if x34fa72d99b5346c3b52217c0310be9c7 and x34fa72d99b5346c3b52217c0310be9c7.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Rename collection success", tostring(x34fa72d99b5346c3b52217c0310be9c7.data.name))
  do
  local xf6f37b18618a47aba0de46a1a690abcd = xa824ebbfaa17487f95e173d3cc78b018:getCollectionSetInfoSummary().collectionSettings
  local x341223df52ca48668334b8c69767aa24 = x34fa72d99b5346c3b52217c0310be9c7.data.collection_shortname
  xf31f4feaea164a9d8157b597c2353dc6.publishService.catalog:withWriteAccessDo("", function()
  xf6f37b18618a47aba0de46a1a690abcd.url_key = x341223df52ca48668334b8c69767aa24
  xa824ebbfaa17487f95e173d3cc78b018:setCollectionSetSettings(xf6f37b18618a47aba0de46a1a690abcd)
  end)
  xddaa718deba64f87b15382b579451708.updatePhotoUrls(x02f96c3157f942b5901e8b7c9d765de8, xf31f4feaea164a9d8157b597c2353dc6.publishService, xa824ebbfaa17487f95e173d3cc78b018)
  end
  else
  local xc75fefe2c4964d80bca7f94504bdb6d6 = tostring(x34fa72d99b5346c3b52217c0310be9c7.error)
  if string.find(xc75fefe2c4964d80bca7f94504bdb6d6, "not exist") ~= nil then
  xf31f4feaea164a9d8157b597c2353dc6.publishService.catalog:withWriteAccessDo("", function(context)
  xa824ebbfaa17487f95e173d3cc78b018:setRemoteId(nil)
  xa824ebbfaa17487f95e173d3cc78b018:setRemoteUrl(nil)
  end)
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Remote collection DOES NOT EXIST, unsetting id and url")
  xc75fefe2c4964d80bca7f94504bdb6d6 = xc75fefe2c4964d80bca7f94504bdb6d6 .. x5438b793d2444916b10a89b716c339d4.CATALOG_SYNC_ERROR
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Unable to rename the Collection on Lightfolio", xc75fefe2c4964d80bca7f94504bdb6d6)
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", xc75fefe2c4964d80bca7f94504bdb6d6)
  if xc75fefe2c4964d80bca7f94504bdb6d6 ~= "" then
  x74383958d2564384ac9ed6cf7dfe1628.throwUserError(xc75fefe2c4964d80bca7f94504bdb6d6)
  end
  end
  end
  end
function x19200da09b414d33933a33548d62156d.renameFolder( xbfeb1f9b9d20409a8bcd3cbc5ff88b7d, xd632b1967ef240ab8db37883c81c1137 )
  local x70d81b8992a943369bfdfcbdf1fdb5a4 = xd632b1967ef240ab8db37883c81c1137.parents[1].remoteCollectionId
  local x5961dd72bb80410fafd1df9ad2de7e55 = xd632b1967ef240ab8db37883c81c1137.remoteId
  local x566622356d08495386224438ed250826 = url_encode(xd632b1967ef240ab8db37883c81c1137.name)
  local x5481d4856d01476b9b579d50db4bdf6d = xd632b1967ef240ab8db37883c81c1137.publishedCollection
  local xef9a8cfe123c4ae1ad1459c02f3cf4b3 = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "UpdateFolder", buildGetRequest(xbfeb1f9b9d20409a8bcd3cbc5ff88b7d) .. string.format("&folder_id=%s&name=%s", x5961dd72bb80410fafd1df9ad2de7e55, x566622356d08495386224438ed250826))
  if xef9a8cfe123c4ae1ad1459c02f3cf4b3 and xef9a8cfe123c4ae1ad1459c02f3cf4b3.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("New folder name ok", tostring(xef9a8cfe123c4ae1ad1459c02f3cf4b3.data.name))
  xd632b1967ef240ab8db37883c81c1137.publishService.catalog:withWriteAccessDo("", function(context)
  x5481d4856d01476b9b579d50db4bdf6d:setRemoteUrl(x19200da09b414d33933a33548d62156d.getCollectionUrl(x70d81b8992a943369bfdfcbdf1fdb5a4, x5961dd72bb80410fafd1df9ad2de7e55)) 
  end)
  else
  local x006e5b5deab1466c89dc2c3dead2d995 = tostring(xef9a8cfe123c4ae1ad1459c02f3cf4b3.error)
  if string.find(x006e5b5deab1466c89dc2c3dead2d995, "not exist") ~= nil then
  xd632b1967ef240ab8db37883c81c1137.publishService.catalog:withWriteAccessDo("", function(context)
  x5481d4856d01476b9b579d50db4bdf6d:setRemoteId(nil)
  x5481d4856d01476b9b579d50db4bdf6d:setRemoteUrl(nil)
  end)
  x03d2b9502f71462893ad0c7f9a9e19ea:warn("Remote Folder DOES NOT EXIST, unsetting id and url")
  x006e5b5deab1466c89dc2c3dead2d995 = x006e5b5deab1466c89dc2c3dead2d995 .. x5438b793d2444916b10a89b716c339d4.CATALOG_SYNC_ERROR
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Unable to rename the Folder on Lightfolio", x006e5b5deab1466c89dc2c3dead2d995)
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", x006e5b5deab1466c89dc2c3dead2d995)
  if x006e5b5deab1466c89dc2c3dead2d995 ~= "" then
  x74383958d2564384ac9ed6cf7dfe1628.throwUserError(x006e5b5deab1466c89dc2c3dead2d995)
  end
  end
  end
  end
function x19200da09b414d33933a33548d62156d.uploadPhoto( xfa0de4e1204445c3b6efbc6c5525b9fd, xb159fb1c1d404e73a4bc80ec119d0de7, xdcbf93fb45414068b2bad2cb3f8edd2b, x55e239c576844f1996dd2212de1f7b22 )
  x03d2b9502f71462893ad0c7f9a9e19ea:info("folderId",xfa0de4e1204445c3b6efbc6c5525b9fd)
  
  
  
  
  local x376d333c20f949b9ba9009561b01414b = x8b36376c6e924bcdbf3f630320de5f7c.removeExtension(xdcbf93fb45414068b2bad2cb3f8edd2b:getFormattedMetadata("fileName"))
  if xdcbf93fb45414068b2bad2cb3f8edd2b:getRawMetadata("isVirtualCopy") and xdcbf93fb45414068b2bad2cb3f8edd2b:getFormattedMetadata("copyName") ~= nil then
  x376d333c20f949b9ba9009561b01414b = x376d333c20f949b9ba9009561b01414b .. "-" .. xdcbf93fb45414068b2bad2cb3f8edd2b:getFormattedMetadata("copyName")
  end
  x376d333c20f949b9ba9009561b01414b = string.gsub(x376d333c20f949b9ba9009561b01414b, " ", "")
  x376d333c20f949b9ba9009561b01414b = x8b36376c6e924bcdbf3f630320de5f7c.addExtension(x376d333c20f949b9ba9009561b01414b, "jpg")
  
  local x357e38e2440943a38729024e87f9faf4 = xa6b8bc5e6ca343c1a84ecfc31d642372.fileAttributes(xb159fb1c1d404e73a4bc80ec119d0de7).fileSize
  if x357e38e2440943a38729024e87f9faf4 > x187a46e2a70e4c9697265835bf122e45.MAX_FILE_SIZE then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Max file size exceeded", x357e38e2440943a38729024e87f9faf4)
  return nil, "95", "Max file size exceeded."
  end
  x03d2b9502f71462893ad0c7f9a9e19ea:info(string.format("Uploading '%s/%s' containing %s bytes", xfa0de4e1204445c3b6efbc6c5525b9fd, x376d333c20f949b9ba9009561b01414b, x357e38e2440943a38729024e87f9faf4))
  local x1a81b4708e104afb85eae1268c7951d6 = {
  {
  name = "employeesGuid",
  value = x55e239c576844f1996dd2212de1f7b22.employeesGuid
  },
  {
  name = "token",
  value = x55e239c576844f1996dd2212de1f7b22.token
  },
  {
  name = "foldersGuid",
  value = xfa0de4e1204445c3b6efbc6c5525b9fd
  },
  {
  name = "qqfilename",
  value = x376d333c20f949b9ba9009561b01414b
  },
  {
  name = "file",
  fileName = x376d333c20f949b9ba9009561b01414b,
  filePath = xb159fb1c1d404e73a4bc80ec119d0de7,
  contentType = "multipart/form-data"
  }
  }
  local xa638584b7ccd405ba86271a4d23c6ac2, x579971686d7a4cd99bb6205e5aa4d23d = xf46a102b660f4b4f99fff91ff8b7c2d1.postMultipart(x411616e1b6704f698b1afc09a58416ed.uploadEndpoint, x1a81b4708e104afb85eae1268c7951d6, nil, x187a46e2a70e4c9697265835bf122e45.TIMEOUT_UPLOAD)
  if not xa638584b7ccd405ba86271a4d23c6ac2 then
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API empty xa638584b7ccd405ba86271a4d23c6ac2: xf46a102b660f4b4f99fff91ff8b7c2d1.postMultipart", xa638584b7ccd405ba86271a4d23c6ac2)
  return nil, "93", "No xa638584b7ccd405ba86271a4d23c6ac2. Please check your internet connection and try again."
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:info("ASHX xa638584b7ccd405ba86271a4d23c6ac2:", xa638584b7ccd405ba86271a4d23c6ac2)
  end
  
  xa638584b7ccd405ba86271a4d23c6ac2 = x31c721477ca74644a40b93d6a3d95fd9:decode(xa638584b7ccd405ba86271a4d23c6ac2)
  if xa638584b7ccd405ba86271a4d23c6ac2 and xa638584b7ccd405ba86271a4d23c6ac2.success then 
  return xa638584b7ccd405ba86271a4d23c6ac2.ImagesGuid, x376d333c20f949b9ba9009561b01414b
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error([[Photo upload failure '%s'.]], x376d333c20f949b9ba9009561b01414b)
  return nil, "94", "Upload failure."
  end
  end
function x19200da09b414d33933a33548d62156d.deletePhotos( x83acb54798bd443eba07080bca4b6371, xa40e372785164cae82c049c32a468173 )
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Deleting remote photos", xa40e372785164cae82c049c32a468173)
  if #xa40e372785164cae82c049c32a468173 == 0 then
  return true
  end
  local x705feb6a8ac043a5884f952b08c0a30f = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "DeleteImages", buildGetRequest(x83acb54798bd443eba07080bca4b6371) .. "&photo_ids=" .. xa40e372785164cae82c049c32a468173)
  if x705feb6a8ac043a5884f952b08c0a30f and x705feb6a8ac043a5884f952b08c0a30f.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Deleted remote photos")
  return true
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(x705feb6a8ac043a5884f952b08c0a30f.error))
  return false
  end
  end
function x19200da09b414d33933a33548d62156d.checkUpdate( xbbc42ec1ec524fedb3c98f874cff78dc )
  xbbc42ec1ec524fedb3c98f874cff78dc = xbbc42ec1ec524fedb3c98f874cff78dc or false
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Check update called")
  local xadad33c224614a9aafc7f8f3da798d06 = x187a46e2a70e4c9697265835bf122e45.PLUGIN_VERSION
  xcc109d897ad64c3eb4671d7832836e67.postAsyncTaskWithContext("Check Update", function(context)
  context:addFailureHandler(function(status, error)
  end)
  x80ee7f16424a4ff08ff39c51c52e66ef.attachErrorDialogToFunctionContext(context)
  local xfdb3bc481ff1465b9d1d4e7ebf4fc4bb = x19200da09b414d33933a33548d62156d.callApi("GET", x0a084b66860c48bc94f8c9ac5d84755c .. "GetPluginVersion", string.format("app_id=%s", _PLUGIN.id))
  if xfdb3bc481ff1465b9d1d4e7ebf4fc4bb and xfdb3bc481ff1465b9d1d4e7ebf4fc4bb.success then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Latest plugin version", xfdb3bc481ff1465b9d1d4e7ebf4fc4bb.data)
  local x494410aca44a4604b85e4664b354fa06
  local x77236e5156ed4205a041c837e90a9a90 = xfdb3bc481ff1465b9d1d4e7ebf4fc4bb.data
  local xeff31a037af24c5ab0e8e2455b90a21d = xfdb3bc481ff1465b9d1d4e7ebf4fc4bb.changelog
  if x411616e1b6704f698b1afc09a58416ed.skipUpdateVersion ~= x77236e5156ed4205a041c837e90a9a90 or xbbc42ec1ec524fedb3c98f874cff78dc then
  if x77236e5156ed4205a041c837e90a9a90 == xadad33c224614a9aafc7f8f3da798d06 then
  if xbbc42ec1ec524fedb3c98f874cff78dc then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("You're good to go!", string.format("Plugin v%s is the latest version.", xadad33c224614a9aafc7f8f3da798d06))
  end
  x411616e1b6704f698b1afc09a58416ed.pluginUpdateStatus = ""
  else
  if x411616e1b6704f698b1afc09a58416ed.sdkCompatible then
  x494410aca44a4604b85e4664b354fa06 = x80ee7f16424a4ff08ff39c51c52e66ef.confirm("Update available", string.format([[
  Lightroom plug-in v%s is now available.
  
  Update summary:
  %s
  ]], x77236e5156ed4205a041c837e90a9a90, xeff31a037af24c5ab0e8e2455b90a21d), "Update Now", "Update Later", "Skip This Version")
  else
  x494410aca44a4604b85e4664b354fa06 = x80ee7f16424a4ff08ff39c51c52e66ef.confirm("Update available", string.format([[
  Lightroom plug-in v%s is now available.
  
  Update summary:
  %s
  
  * Click 'Download' to visit the Lightfolio website where you can manually install the new plug-in:
  
  %s]], x77236e5156ed4205a041c837e90a9a90, xeff31a037af24c5ab0e8e2455b90a21d, _PLUGIN.path), "Download", "Update Later", "Skip This Version")
  end
  x411616e1b6704f698b1afc09a58416ed.pluginUpdateStatus = string.format("Update v%s available", x77236e5156ed4205a041c837e90a9a90)
  end
  if x494410aca44a4604b85e4664b354fa06 == "ok" and not x411616e1b6704f698b1afc09a58416ed.sdkCompatible then
  xf46a102b660f4b4f99fff91ff8b7c2d1.openUrlInBrowser(x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_MKT_URL)
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Manual update required", "After downloading and unzipping the new version, complete the update by restarting Lightroom.")
  elseif x494410aca44a4604b85e4664b354fa06 == "ok" and x411616e1b6704f698b1afc09a58416ed.sdkCompatible then
  local x3c91dfa65ef346b5b111bf255eb11471 = string.format("lightfolio-%s.lrplugin.zip", x77236e5156ed4205a041c837e90a9a90)
  local x7d53324096a646c0a1da213f9f5ad795 = x84a0312622714ecaa30b5010f1ea1287.getFile(x187a46e2a70e4c9697265835bf122e45.URLS.LIGHTFOLIO_MKT_URL .. x3c91dfa65ef346b5b111bf255eb11471, x3c91dfa65ef346b5b111bf255eb11471)
  local xa27ff7fb2c7348e8a42710f036dae808 = x8b36376c6e924bcdbf3f630320de5f7c.makeAbsolute("", _PLUGIN.path)
  xa27ff7fb2c7348e8a42710f036dae808 = x8b36376c6e924bcdbf3f630320de5f7c.parent(xa27ff7fb2c7348e8a42710f036dae808)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Plugin parent path", xa27ff7fb2c7348e8a42710f036dae808)
  if xa6b8bc5e6ca343c1a84ecfc31d642372.isWritable(xa27ff7fb2c7348e8a42710f036dae808) or not xa6b8bc5e6ca343c1a84ecfc31d642372.exists(xa27ff7fb2c7348e8a42710f036dae808) then
  local x4b72c32d0da24af5aa04e1263dfaf56e = string.format("lightfolio-%s-backup.lrplugin", xadad33c224614a9aafc7f8f3da798d06)
  x84a0312622714ecaa30b5010f1ea1287.makeBackup("lightfolio.lrplugin", x4b72c32d0da24af5aa04e1263dfaf56e)
  if x84a0312622714ecaa30b5010f1ea1287.unzip(x7d53324096a646c0a1da213f9f5ad795, xa27ff7fb2c7348e8a42710f036dae808, x4b72c32d0da24af5aa04e1263dfaf56e) then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Success!", "Please restart Lightroom or reload the plugin from the Lightroom Plug-in Manager.")
  xa6b8bc5e6ca343c1a84ecfc31d642372.delete(x7d53324096a646c0a1da213f9f5ad795)
  else
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Auto update failed", "Please try again or manually install the latest version.", "critical")
  x74383958d2564384ac9ed6cf7dfe1628.throwCanceled()
  end
  end
  x411616e1b6704f698b1afc09a58416ed.pluginUpdateStatus = ""
  elseif x494410aca44a4604b85e4664b354fa06 == "other" then
  x03d2b9502f71462893ad0c7f9a9e19ea:info("Skipping this update")
  x411616e1b6704f698b1afc09a58416ed.skipUpdateVersion = x77236e5156ed4205a041c837e90a9a90
  end
  end
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:error("Lightfolio API error:", tostring(xfdb3bc481ff1465b9d1d4e7ebf4fc4bb.error))
  end
  end)
  end
function syncLightboxes(xd4203c30421a43f6a86822db7ef43aca, xd673944e3113459ebc8dbcfe4ef52fc1, x3047fdeb71e940049b39ce1558260bea)
  local x6143945dfca54c1ba6b3be0a945ddec7 = xd4203c30421a43f6a86822db7ef43aca.LR_publishService
  
  x03d2b9502f71462893ad0c7f9a9e19ea:tracef("start syncLightboxes")
  
  local function x1287ef150cf14dc19ac0521373727324(x3047fdeb71e940049b39ce1558260bea)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("syncLightboxes x1287ef150cf14dc19ac0521373727324")
  x80ee7f16424a4ff08ff39c51c52e66ef.attachErrorDialogToFunctionContext(x3047fdeb71e940049b39ce1558260bea)
  x3047fdeb71e940049b39ce1558260bea:addFailureHandler(function()
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]:")
  
  end)
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("before getLightboxGalleryFolders")
  
  
  local xb924eed837e1447997383852761d5d79 = getLightboxGalleryFolders(x6143945dfca54c1ba6b3be0a945ddec7)
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("after getLightboxGalleryFolders")
  
  if not xb924eed837e1447997383852761d5d79 or xb924eed837e1447997383852761d5d79 == {} then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("No active galleries in catalog.")
  return
  elseif not xd673944e3113459ebc8dbcfe4ef52fc1 or xd673944e3113459ebc8dbcfe4ef52fc1 == {} then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("No server galleries.")
  return
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("iterate xd673944e3113459ebc8dbcfe4ef52fc1")
  
  
  
  
  
  
  
  
  
  
  
  for _, gallery in pairs(xd673944e3113459ebc8dbcfe4ef52fc1) do
  
  local xbc000ffa09c2467a82fd7c1a15d47960 = gallery.collection_id
  x03d2b9502f71462893ad0c7f9a9e19ea:info("gallery xbc000ffa09c2467a82fd7c1a15d47960: ", xbc000ffa09c2467a82fd7c1a15d47960)
  
  
  if xb924eed837e1447997383852761d5d79[xbc000ffa09c2467a82fd7c1a15d47960] then
  x6143945dfca54c1ba6b3be0a945ddec7.catalog:withWriteAccessDo("syncLightboxes", function()
  local x20ac0c25696f46619455f6dddc5f4d90 = gallery.lightboxFolders or {} 
  local xd2931fe9c12b412c9b7778231207084e = xb924eed837e1447997383852761d5d79[xbc000ffa09c2467a82fd7c1a15d47960].lightboxFolders 
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("# x20ac0c25696f46619455f6dddc5f4d90", #x20ac0c25696f46619455f6dddc5f4d90)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("# xd2931fe9c12b412c9b7778231207084e", #xd2931fe9c12b412c9b7778231207084e)
  
  
  for _, sFolder in pairs(x20ac0c25696f46619455f6dddc5f4d90) do 
  
  
  if starts_with(sFolder.folder_name, "LB:") then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phase 2: Entered lightboxes: " .. sFolder.folder_name .. " (find " .. #sFolder.photosIds .. " images)")
  
  
  local xc4d6ea161d5849ca91174a76470e3d05 = tostring(sFolder.folder_id) 
  x03d2b9502f71462893ad0c7f9a9e19ea:info("sFolder.folderId", sFolder.folder_id)
  
  local xc867011fee6d4e51a3a6b8f56aaf8e79 = xd2931fe9c12b412c9b7778231207084e[xc4d6ea161d5849ca91174a76470e3d05]
  local x3bb27875a615415391b62185da860963 = xc867011fee6d4e51a3a6b8f56aaf8e79 and xc867011fee6d4e51a3a6b8f56aaf8e79.photos or {} 
  xc867011fee6d4e51a3a6b8f56aaf8e79 = xc867011fee6d4e51a3a6b8f56aaf8e79 and xc867011fee6d4e51a3a6b8f56aaf8e79.folder or nil 
  
  local x40544156601840cd8ac30eec7377c4e9 = {} 
  
  local x8106cf3facfa4af1b2d87e4fe208c0e9 = arrayToTable(sFolder.photosIds)
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: getRemoteId: " .. xc867011fee6d4e51a3a6b8f56aaf8e79:getRemoteId())
  
  
  if xc867011fee6d4e51a3a6b8f56aaf8e79 then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: lightbox was synced before")
  
  
  
  if xc867011fee6d4e51a3a6b8f56aaf8e79:getName() ~= sFolder.folder_name and not xc867011fee6d4e51a3a6b8f56aaf8e79:setName(sFolder.folder_name) then
  local x4bf4fc139ff74e939535545ec2cf173f = 0
  
  while not xc867011fee6d4e51a3a6b8f56aaf8e79:setName(sFolder.folder_name .. x4bf4fc139ff74e939535545ec2cf173f) do
  x4bf4fc139ff74e939535545ec2cf173f = x4bf4fc139ff74e939535545ec2cf173f + 1
  end
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: name updated")
  
  
  
  
  
  
  xd2931fe9c12b412c9b7778231207084e[xc4d6ea161d5849ca91174a76470e3d05].justUpdatedFlag = true 
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: flag set")
  
  
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phase 3: entering photos update in lightbox")
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: table array created")
  
  
  x40544156601840cd8ac30eec7377c4e9 = findAndMoveLightboxPhotos(x6143945dfca54c1ba6b3be0a945ddec7, xb924eed837e1447997383852761d5d79[xbc000ffa09c2467a82fd7c1a15d47960].gallery, xc867011fee6d4e51a3a6b8f56aaf8e79, x3bb27875a615415391b62185da860963, x8106cf3facfa4af1b2d87e4fe208c0e9)
  
  else 
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: new lightbox, attempting to create")
  
  
  xc867011fee6d4e51a3a6b8f56aaf8e79 = x6143945dfca54c1ba6b3be0a945ddec7:createPublishedCollection(sFolder.folder_name, nil, nil)
  if not xc867011fee6d4e51a3a6b8f56aaf8e79 then
  local x4bf4fc139ff74e939535545ec2cf173f = 1
  while not xc867011fee6d4e51a3a6b8f56aaf8e79 do
  xc867011fee6d4e51a3a6b8f56aaf8e79 = x6143945dfca54c1ba6b3be0a945ddec7:createPublishedCollection(sFolder.folder_name .. " " .. x4bf4fc139ff74e939535545ec2cf173f, nil, nil)
  x4bf4fc139ff74e939535545ec2cf173f = x4bf4fc139ff74e939535545ec2cf173f + 1
  end
  end
  
  
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("setting RemoteId to " .. xc4d6ea161d5849ca91174a76470e3d05)
  xc867011fee6d4e51a3a6b8f56aaf8e79:setRemoteId(xc4d6ea161d5849ca91174a76470e3d05)
  
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phase 3: entering photos update in lightbox")
  
  x40544156601840cd8ac30eec7377c4e9 = findAndMoveLightboxPhotos(x6143945dfca54c1ba6b3be0a945ddec7, xb924eed837e1447997383852761d5d79[xbc000ffa09c2467a82fd7c1a15d47960].gallery, xc867011fee6d4e51a3a6b8f56aaf8e79, x3bb27875a615415391b62185da860963, x8106cf3facfa4af1b2d87e4fe208c0e9)
  end
  
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phase 4: updating Url and lightbox settings")
  
  
  
  if xc867011fee6d4e51a3a6b8f56aaf8e79 then
  
  
  local xd1f04cc65cec4c36a999fc9ec7b837ba = x19200da09b414d33933a33548d62156d.getLightboxUrl(gallery.collection_id, xc4d6ea161d5849ca91174a76470e3d05)
  xc867011fee6d4e51a3a6b8f56aaf8e79:setRemoteUrl(xd1f04cc65cec4c36a999fc9ec7b837ba)
  
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace(string.format("[syncLightboxes]: Phase 5: evaluating missing lightbox images, %d found", #x40544156601840cd8ac30eec7377c4e9))
  
  
  
  
  if x40544156601840cd8ac30eec7377c4e9 and #x40544156601840cd8ac30eec7377c4e9 > 0 then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: " .. string.format("#x40544156601840cd8ac30eec7377c4e9 %d", #x40544156601840cd8ac30eec7377c4e9))
  local x8106cf3facfa4af1b2d87e4fe208c0e9 = arrayToTable(sFolder.photosIds)
  local xef2df89d11314d45bd827cdb0059b880 = ""
  for xbc000ffa09c2467a82fd7c1a15d47960, photo in pairs(x8106cf3facfa4af1b2d87e4fe208c0e9) do
  if not x40544156601840cd8ac30eec7377c4e9[xbc000ffa09c2467a82fd7c1a15d47960] then
  xef2df89d11314d45bd827cdb0059b880 = xef2df89d11314d45bd827cdb0059b880 .. tostring(xbc000ffa09c2467a82fd7c1a15d47960) .. ", "
  end
  end
  
  if xef2df89d11314d45bd827cdb0059b880 ~= "" then
  x80ee7f16424a4ff08ff39c51c52e66ef.message("Lightbox sync error", string.format("The following photos couldn't be added to lightbox %s: %s", sFolder.folder_name, xef2df89d11314d45bd827cdb0059b880))
  end
  end
  end
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phase 6: cleanup")
  
  
  for cfid, folder in ipairs(xd2931fe9c12b412c9b7778231207084e) do 
  if not folder.justUpdatedFlag then
  
  folder.folder:delete()
  end
  end
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("[syncLightboxes]: Phases completed")
  end)
  end
  end
  
  x80ee7f16424a4ff08ff39c51c52e66ef.message(string.format("Done importing galleries, number of galleries imported: %s", #xd673944e3113459ebc8dbcfe4ef52fc1)) 
  end
  
  local x2241b26d154a40b181d06daa066838af = x4f5817500d3e455bb9224cd46f4fcf2c.pcall(function()
  x1287ef150cf14dc19ac0521373727324(x3047fdeb71e940049b39ce1558260bea)
  end, x3047fdeb71e940049b39ce1558260bea)
  
  if not x2241b26d154a40b181d06daa066838af then
  x03d2b9502f71462893ad0c7f9a9e19ea:error("syncLightboxes: Error: The process has failed.")
  end
  end
function getLightboxGalleryFolders(x71989c519d6745559e0b3aca31d2ecc2)
  local xb37e96e5927e4af599b5e2e59968132e = x71989c519d6745559e0b3aca31d2ecc2:getChildCollectionSets()
  local xe596d43e4dee44328f3db719e34678f0 = {}
  
  
  
  
  for _, gallery in ipairs(xb37e96e5927e4af599b5e2e59968132e) do
  
  local x061df0ed43634e8bbb15a9c6fc22e422 = gallery:getRemoteId() 
  local xcf94f1c94d4b4005841c73c15c24f0dd = x061df0ed43634e8bbb15a9c6fc22e422 and gallery:getChildren() or {}
  local x3cb5112ac6c14c35b4f41dfe0d9551cd = {}
  
  
  for _, folder in ipairs(xcf94f1c94d4b4005841c73c15c24f0dd) do
  
  
  if starts_with(folder:getName(), "LB:") then 
  
  
  local x0929378a33174c26bd4ae854d0f8acdc = folder:getRemoteId()
  local x8f22a9a9c98a4bf1bc3f23771bfc5ff6 = {}
  
  
  for _, publishedPhoto in ipairs(folder:getPublishedPhotos()) do
  local xc96b7cf7630a4b4488d62cbba0aadae2 = publishedPhoto:getPhoto()
  local x3c28c62b727944abb6ac2e8bb87de9bd = xc96b7cf7630a4b4488d62cbba0aadae2:getPropertyForPlugin(_PLUGIN, "images_guid")
  x3c28c62b727944abb6ac2e8bb87de9bd = string.upper(x3c28c62b727944abb6ac2e8bb87de9bd)
  
  if x3c28c62b727944abb6ac2e8bb87de9bd then
  
  x8f22a9a9c98a4bf1bc3f23771bfc5ff6[tostring(x3c28c62b727944abb6ac2e8bb87de9bd)] = publishedPhoto 
  end
  end
  x3cb5112ac6c14c35b4f41dfe0d9551cd[tostring(x0929378a33174c26bd4ae854d0f8acdc)] = {folder = folder, photos = x8f22a9a9c98a4bf1bc3f23771bfc5ff6} 
  end
  end
  
  
  if x061df0ed43634e8bbb15a9c6fc22e422 then
  xe596d43e4dee44328f3db719e34678f0[x061df0ed43634e8bbb15a9c6fc22e422] = { 
  gallery = gallery,
  lightboxFolders = x3cb5112ac6c14c35b4f41dfe0d9551cd
  }
  end
  
  end
  
  return xe596d43e4dee44328f3db719e34678f0
  end
function starts_with(xe66e7cfa7c71471f817269eb5b8aa3b5, x9629cda15ae34608b18469ea0c589355)
  return xe66e7cfa7c71471f817269eb5b8aa3b5:sub(1, #x9629cda15ae34608b18469ea0c589355) == x9629cda15ae34608b18469ea0c589355
  end
function findAndMoveLightboxPhotos(xb1d02d11fd9f4741b97bdca0110b2eae, x4227650e9626470b902cb35f2b2571c1, xfb854f1168d3438784b9f8017d9ee401, x312f5b527e2041118f34fe4e2b5e9d77, x6a9628a2da5e4079b0fe9afbf2f96106)
  local x89249f4cf1904e33aafc54c1cefbd8fe = x4227650e9626470b902cb35f2b2571c1:getChildCollections()
  local xbe7a0059628341d7b005b0a24d40bcfb = {}
  local xe40ed46f15c64f9ebd1d2e1d48ab622e = {}
  local xebab6c71169d4716b1787f30346f12da = {}
  
  
  for _, folder in pairs(x89249f4cf1904e33aafc54c1cefbd8fe) do 
  
  
  
  local xa10f1d9133f74767a9e2bc2b49658ba2 = folder:getPublishedPhotos()
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info(string.format("[findAndMoveLightboxPhotos]: inspecting folder: %s (%d images). ", folder:getName(), #xa10f1d9133f74767a9e2bc2b49658ba2))
  
  
  for _, publishedPhoto in ipairs(xa10f1d9133f74767a9e2bc2b49658ba2) do
  local xfe2cd3adc71e4e70bbbc4a03bae39dc1 = publishedPhoto:getPhoto()
  local x107fc2d2427b45a7914530d3e4148efb = xfe2cd3adc71e4e70bbbc4a03bae39dc1:getPropertyForPlugin(_PLUGIN, "images_guid") 
  x107fc2d2427b45a7914530d3e4148efb = string.upper(x107fc2d2427b45a7914530d3e4148efb)
  
  
  
  if(x107fc2d2427b45a7914530d3e4148efb) then
  
  
  
  
  
  
  if x6a9628a2da5e4079b0fe9afbf2f96106[x107fc2d2427b45a7914530d3e4148efb] and not x312f5b527e2041118f34fe4e2b5e9d77[x107fc2d2427b45a7914530d3e4148efb] and not xebab6c71169d4716b1787f30346f12da[x107fc2d2427b45a7914530d3e4148efb] then
  
  
  
  
  table.insert(xbe7a0059628341d7b005b0a24d40bcfb, publishedPhoto)
  xebab6c71169d4716b1787f30346f12da[x107fc2d2427b45a7914530d3e4148efb] = publishedPhoto 
  x03d2b9502f71462893ad0c7f9a9e19ea:debugf("[findAndMoveLightboxPhotos]: Adding a xfe2cd3adc71e4e70bbbc4a03bae39dc1 object with id: %s", x107fc2d2427b45a7914530d3e4148efb)
  
  
  elseif not x6a9628a2da5e4079b0fe9afbf2f96106[x107fc2d2427b45a7914530d3e4148efb] and x312f5b527e2041118f34fe4e2b5e9d77[x107fc2d2427b45a7914530d3e4148efb] then
  table.insert(xe40ed46f15c64f9ebd1d2e1d48ab622e, xfe2cd3adc71e4e70bbbc4a03bae39dc1)
  x03d2b9502f71462893ad0c7f9a9e19ea:debugf("[findAndMoveLightboxPhotos]: Removing a xfe2cd3adc71e4e70bbbc4a03bae39dc1 object with id: %s", x107fc2d2427b45a7914530d3e4148efb)
  else
  x03d2b9502f71462893ad0c7f9a9e19ea:info("[findAndMoveLightboxPhotos]: x107fc2d2427b45a7914530d3e4148efb not found anywhere", x107fc2d2427b45a7914530d3e4148efb)
  end
  end
  end
  
  end
  
  local x0f2d789be6d14354b91d342435fc9994
  local x0785d49226b24efe83cbfb5965dd65e6 = {}
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("before loop")
  for i, publishedPhoto in ipairs(xbe7a0059628341d7b005b0a24d40bcfb) do 
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("in loop")
  
  
  local xfe2cd3adc71e4e70bbbc4a03bae39dc1 = publishedPhoto:getPhoto()
  x03d2b9502f71462893ad0c7f9a9e19ea:trace("got xfe2cd3adc71e4e70bbbc4a03bae39dc1")
  local x107fc2d2427b45a7914530d3e4148efb = xfe2cd3adc71e4e70bbbc4a03bae39dc1:getPropertyForPlugin(_PLUGIN, "images_guid") 
  x107fc2d2427b45a7914530d3e4148efb = string.upper(x107fc2d2427b45a7914530d3e4148efb)
  
  x03d2b9502f71462893ad0c7f9a9e19ea:info("publishedPhoto: ", publishedPhoto)
  x03d2b9502f71462893ad0c7f9a9e19ea:info("publishedPhoto images_guid: ", x107fc2d2427b45a7914530d3e4148efb)
  
  x0f2d789be6d14354b91d342435fc9994 = x4f5817500d3e455bb9224cd46f4fcf2c.pcall(function()
  
  local x43476a76bfdb46549bf0c885c8f6e19e = {}
  table.insert(x43476a76bfdb46549bf0c885c8f6e19e, publishedPhoto)
  xfb854f1168d3438784b9f8017d9ee401:addPublishedPhotos(x43476a76bfdb46549bf0c885c8f6e19e)
  end, xfb854f1168d3438784b9f8017d9ee401, publishedPhoto)
  
  if not x0f2d789be6d14354b91d342435fc9994 then
  x03d2b9502f71462893ad0c7f9a9e19ea:tracef("[findAndMoveLightboxPhotos]: Failed adding xfe2cd3adc71e4e70bbbc4a03bae39dc1 to folder, skipping: x107fc2d2427b45a7914530d3e4148efb %s", x107fc2d2427b45a7914530d3e4148efb)
  table.insert(x0785d49226b24efe83cbfb5965dd65e6, x107fc2d2427b45a7914530d3e4148efb)
  end
  end
  
  
  
  if #x0785d49226b24efe83cbfb5965dd65e6 > 0 then
  
  
  x80ee7f16424a4ff08ff39c51c52e66ef.message(string.format("Failed to add %d xa10f1d9133f74767a9e2bc2b49658ba2 to lightbox: %s", #x0785d49226b24efe83cbfb5965dd65e6, xfb854f1168d3438784b9f8017d9ee401:getName()))
  end
  
  
  
  if #xe40ed46f15c64f9ebd1d2e1d48ab622e > 0 then
  x0f2d789be6d14354b91d342435fc9994 = x4f5817500d3e455bb9224cd46f4fcf2c.pcall(function()
  xfb854f1168d3438784b9f8017d9ee401:removePhotos(xe40ed46f15c64f9ebd1d2e1d48ab622e)
  end, xfb854f1168d3438784b9f8017d9ee401, xe40ed46f15c64f9ebd1d2e1d48ab622e)
  if not x0f2d789be6d14354b91d342435fc9994 then
  x03d2b9502f71462893ad0c7f9a9e19ea:trace(string.format("Failed removing xa10f1d9133f74767a9e2bc2b49658ba2 from lightbox: %s", xfb854f1168d3438784b9f8017d9ee401:getName()))
  else
  
  xfb854f1168d3438784b9f8017d9ee401:publishNow() 
  end
  end
  
  return xebab6c71169d4716b1787f30346f12da
  end
